unit Unit1;

interface

{==============================================================================}
{ This demo shows how checkpoints can generate events when they become visible }
{------------------------------------------------------------------------------}
{ Properties set:                                                              }
{  srv1.RichViewEdit.CPEventKind = cpeAsSectionStart                                   }
{  srv2.RichViewEdit.CPEventKind = cpeWhenVisible                                      }
{  rvoShowCheckpoints included in Options of both RichViews                    }
{------------------------------------------------------------------------------}
{ Key properties, events and methods:                                          }
{ - CPEventKind                                                                }
{ - OnCheckpointVisible                                                        }
{ - AddNamedCheckpointEx                                                       }
{==============================================================================}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RVStyle, RVScroll, RichView, CRVData, ExtCtrls, SclRView;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    Label1: TLabel;
    lblChapter: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lblFigure: TLabel;
    Image1: TImage;
    Label5: TLabel;
    srv1: TSRichViewEdit;
    srv2: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure srv1CheckpointVisible(Sender: TSRichViewEdit;
      RVData: TCustomRVData; ItemNo: Integer);
    procedure srv2CheckpointVisible(Sender: TSRichViewEdit;
      RVData: TCustomRVData; ItemNo: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var i, j: Integer;
    ico: TIcon;
begin
  srv1.SetMargin(5, 5, 5, 5);
  srv2.SetMargin(5, 5, 5, 5);

  // 1. Filling in left RichView
  for i := 1 to 3 do begin
    srv1.RichViewEdit.AddNamedCheckpointEx('Chapter '+IntToStr(i),True);
    srv1.RichViewEdit.AddFmt('Chapter %d', [i], 1,1);
    for j := 0 to 30 do
      srv1.RichViewEdit.AddNL('Bla - bla - bla - bla - bla - bla.',0,0);
  end;
  srv1.RichViewEdit.Format;
  // 2. Filling in right RichView
  for i := 1 to 3 do begin
    srv2.RichViewEdit.AddNamedCheckpointEx('Figure '+IntToStr(i),True);
    ico := TIcon.Create;
    ico.Assign(Image1.Picture.Graphic);
    srv2.RichViewEdit.AddPictureEx('', ico, 1, rvvaBaseline);
    srv2.RichViewEdit.AddFmt('Figure %d', [i], 3,1);
    for j := 0 to 30 do
      srv2.RichViewEdit.AddNL('Bla - bla - bla - bla - bla - bla.',0,0);
  end;
  srv2.RichViewEdit.Format;
  {
    Comments:

    1.
    In this demo we use AddNamedCheckpointEx method.
    It has second parameter - RaiseEvent: Boolean.
    If set to True, RichView will generate event when this checkpoint
    becomes visible

    2.
    Checkpoints with RaiseEvent=True can be displayed with different color
    than other checkpoints.
    Color of "normal" checkpoints: RVStyle.CheckpointColor;
    Color of "RaiseEvent" checkpoints: RVStyle.CheckpointEvColor
  }
end;

procedure TForm1.srv1CheckpointVisible(Sender: TSRichViewEdit;
  RVData: TCustomRVData; ItemNo: Integer);
var Name: String;
    Tag: Integer;
    RE: Boolean;
    CheckpointData : TCheckpointData;
begin
  if RVData <> nil then begin
    CheckpointData := RVData.GetItemCheckpoint(ItemNo);
    srv1.RichViewEdit.GetCheckpointInfo(CheckpointData, Tag, Name, RE);
    lblChapter.Caption := Name;
  end;
end;

procedure TForm1.srv2CheckpointVisible(Sender: TSRichViewEdit;
  RVData: TCustomRVData; ItemNo: Integer);
var Name: String;
    Tag: Integer;
    RE: Boolean;
    CheckpointData : TCheckpointData;
begin
  if RVData <> nil then begin
    CheckpointData := RVData.GetItemCheckpoint(ItemNo);
    srv2.RichViewEdit.GetCheckpointInfo(CheckpointData, Tag, Name, RE);
    lblFigure.Caption := Name;
    end
  else
    lblFigure.Caption := '(none)';
end;

end.
